;------------------------------------------------------------------------
; Radikal Bikers
; Radikal Bikers Emu v0.9.0.1
; by djvj
; 1.0
;
; Notes:
; radikalb.zip rom must reside in the emulator directory and be zipped. Copy it from your mame set.
; Run the emu manuallly initially and set your resolution and control you want to use. It gets saved in the radikalb.dat
; 
; To use this in your MAME wheel:
; Add the <exe>RadikalBikersEmu</exe> tag to the "radikalb" entry in your database
; Create a RadikalBikersEmu folder in your Modules folder and place this script in there. The name of this script must match the exe tag in your database
; Create a RadikalBikersEmu.ini in your Hyperspin\Settings folder. Open your MAME.ini in this folder and copy the [exe info] section into the RadikalBikersEmu.ini and change the "path" and "exe" to this emulator. Rompath should also point to the emu dir because your rom resides in there now.
;------------------------------------------------------------------------

LoadingScreen = true

; This gets rid of the emu window that pops up on launch
If ( LoadingScreen = "true" ) {
		Gui +AlwaysOnTop -Caption +ToolWindow
		Gui Color, Black
		Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
	}

Run, %executable%, %emuPath%
WinWait, AHK_class #32770
WinActivate, AHK_class #32770
Send, {ENTER} ; starting game
 
Sleep, 2000 ; increase if black screen disappears before game starts
Gui Destroy

;(`._.`._.`._.`._.`._.`._.`._.)
; Remap your controls here (defaults are already provided), just place your key to the left of the :: and uncomment the line
; Example  to_key::from_key

; System Controls
; ::9				; Service Coin
; ::F2			; Test Mode
; ::F9			; Display FPS (windowed mode only)
; ::F10			; Toggle Throttling
; ::p				; Pause
; ::Escape		; Quit

; Player 1 Controls
; ::Down		; Handlebars up
; ::Left			; Steer Left
; ::Right		; Steer Right
; ::LControl	; Accelerate
; ::LAlt 			; Brake
; ::Space		; Change View
; ::1				; Start
; ::5				; Coin
;(_.`._.`._.`._.`._.`._.`._.`._)

Process, WaitClose, %executable%

ExitApp

CloseProcess:
Return